# 🚀 cPanel Installation Guide - OTP Selling System

## Overview

Yeh guide aapko step-by-step batayega ke OTP System ko cPanel par kaise install karna hai.

---

## Prerequisites

- Active cPanel hosting account
- Domain name pointing to your hosting
- FTP or SSH access
- Basic knowledge of cPanel

---

## Step 1: Create MySQL Database

### Via cPanel Dashboard:

1. **Login to cPanel**
   - Go to `https://yourdomain.com:2083`
   - Enter your cPanel username and password

2. **Navigate to MySQL Databases**
   - Search for "MySQL Databases" in cPanel
   - Click on it

3. **Create New Database**
   - Under "Create New Database"
   - Database Name: `otp_system` (or your preferred name)
   - Click "Create Database"
   - Note: Full name will be `cpaneluser_otp_system`

4. **Create Database User**
   - Under "MySQL Users"
   - Username: `otp_user` (or your preferred name)
   - Password: Create a strong password
   - Confirm Password: Re-enter password
   - Click "Create User"
   - Note: Full username will be `cpaneluser_otp_user`

5. **Add User to Database**
   - Under "Add User to Database"
   - User: Select the user you just created
   - Database: Select the database you just created
   - Click "Add"

6. **Set Privileges**
   - Select "ALL PRIVILEGES"
   - Click "Make Changes"

**Important Notes:**
- Remember your full database name: `cpaneluser_otp_system`
- Remember your full database user: `cpaneluser_otp_user`
- Remember your database password
- Database Host: `localhost`

---

## Step 2: Upload System Files

### Method 1: Using File Manager (Easiest)

1. **Open File Manager**
   - In cPanel, search for "File Manager"
   - Click on it
   - Make sure "public_html" is selected

2. **Create OTP System Folder**
   - Right-click in empty space
   - Click "Create New Folder"
   - Name: `otp_system`
   - Click "Create New Folder"

3. **Upload Files**
   - Double-click `otp_system` folder to enter
   - Click "Upload" button
   - Select all system files
   - Drag and drop or browse and select
   - Wait for upload to complete

4. **Create Uploads Folder**
   - Inside `otp_system` folder
   - Right-click → "Create New Folder"
   - Name: `uploads`
   - Click "Create New Folder"

### Method 2: Using FTP

1. **Connect via FTP**
   - Use FTP client (FileZilla, WinSCP, etc.)
   - Host: `ftp.yourdomain.com`
   - Username: Your cPanel username
   - Password: Your cPanel password
   - Port: 21

2. **Navigate to public_html**
   - Double-click `public_html` folder

3. **Create otp_system Folder**
   - Right-click → "Create folder"
   - Name: `otp_system`

4. **Upload All Files**
   - Drag and drop all system files into `otp_system` folder
   - Or use "Upload" option

5. **Create uploads Folder**
   - Inside `otp_system`
   - Right-click → "Create folder"
   - Name: `uploads`

---

## Step 3: Set File Permissions

### Via File Manager:

1. **Select uploads Folder**
   - Right-click on `uploads` folder
   - Click "Change Permissions"
   - Set to: `755`
   - Click "Change Permissions"

2. **Select config.php**
   - Right-click on `config.php`
   - Click "Change Permissions"
   - Set to: `644`
   - Click "Change Permissions"

3. **Select .htaccess**
   - Right-click on `.htaccess`
   - Click "Change Permissions"
   - Set to: `644`
   - Click "Change Permissions"

### Via SSH (Advanced):

```bash
# Connect to server
ssh cpaneluser@yourdomain.com

# Navigate to folder
cd public_html/otp_system

# Set permissions
chmod 755 uploads
chmod 644 config.php
chmod 644 .htaccess
chmod 644 install.php
chmod 644 login.php
chmod 644 register.php
chmod 644 proxy.php
chmod 644 database.sql
```

---

## Step 4: Run Installation Wizard

1. **Open Browser**
   - Go to: `http://yourdomain.com/otp_system/install.php`
   - Or: `https://yourdomain.com/otp_system/install.php`

2. **Fill Database Information**
   - **Database Host**: `localhost`
   - **Database User**: `cpaneluser_otp_user` (full name from Step 1)
   - **Database Password**: Your database password
   - **Database Name**: `cpaneluser_otp_system` (full name from Step 1)
   - **Site URL**: `http://yourdomain.com/otp_system/` (with trailing slash)
   - Click "Continue to Step 2"

3. **Create Admin Account**
   - **Admin Email**: Your admin email
   - **Admin Password**: Strong password (min 6 characters)
   - **Confirm Password**: Re-enter password
   - Click "Complete Installation"

4. **Installation Complete**
   - You'll see success message
   - Click "Go to Login"

---

## Step 5: First Login

1. **Login to System**
   - URL: `http://yourdomain.com/otp_system/login.php`
   - Email: Your admin email
   - Password: Your admin password
   - Click "Login"

2. **Admin Dashboard**
   - You should see admin dashboard
   - Click menu items to explore

---

## Step 6: Initial Setup

### Add Payment Methods

1. **Go to Admin Dashboard**
   - Click "Payment Methods"

2. **Add Payment Method**
   - Click "Add Payment Method"
   - Method Name: e.g., "Bank Transfer"
   - Method Details: Bank account info
   - Click "Add Method"

3. **Add More Methods** (Optional)
   - Repeat for PayPal, Crypto, etc.

### Set Prices

1. **Go to Settings**
   - Click "Settings"

2. **Set Prices**
   - WhatsApp Price: e.g., $5.00
   - Facebook Price: e.g., $3.00
   - Click "Save Settings"

### Add OTP Numbers

1. **Go to Manage OTP Numbers**
   - Click "Manage OTP Numbers"

2. **Bulk Upload**
   - Service Type: WhatsApp or Facebook
   - Price: Set price
   - Upload TXT File (format: phone|link)
   - Click "Upload OTP Numbers"

3. **Or Manual Add**
   - Phone Number: Enter number
   - OTP Link: Enter link
   - Service Type: Select type
   - Price: Set price
   - Click "Add OTP Number"

---

## Troubleshooting

### Issue: "Connection failed" during installation

**Solution:**
1. Verify database credentials are correct
2. Check database name includes cPanel username prefix
3. Verify user was added to database
4. Try using `localhost` instead of IP address
5. Check MySQL is running in cPanel

**Steps:**
- Go to cPanel → MySQL Databases
- Verify database exists
- Verify user exists
- Verify user is assigned to database

### Issue: "Permission denied" errors

**Solution:**
1. Set uploads folder to 755
2. Set config.php to 644
3. Set .htaccess to 644

**Via File Manager:**
- Right-click file → Change Permissions
- Set appropriate permissions
- Click "Change Permissions"

### Issue: Installer keeps redirecting

**Solution:**
1. Delete `installed.lock` file
2. Clear browser cache
3. Try in different browser
4. Try incognito/private mode
5. Run installer again

**To delete installed.lock:**
- File Manager → otp_system folder
- Right-click `installed.lock`
- Click "Delete"

### Issue: Can't login after installation

**Solution:**
1. Verify admin email is correct
2. Check password (case-sensitive)
3. Clear browser cookies
4. Try different browser
5. Check database connection

**Steps:**
- Go to cPanel → MySQL Databases
- Click "phpMyAdmin"
- Select your database
- Click "users" table
- Verify admin user exists

### Issue: "File not found" errors

**Solution:**
1. Verify all files were uploaded
2. Check file names are correct
3. Verify folder structure
4. Check file permissions

**Verify Upload:**
- File Manager → otp_system folder
- Should see: config.php, login.php, register.php, etc.
- Should see folders: user, admin, uploads

### Issue: Database errors

**Solution:**
1. Verify database credentials
2. Check MySQL is running
3. Verify database exists
4. Verify user has privileges

**Check Database:**
- cPanel → MySQL Databases
- Verify database name
- Verify user exists
- Click "Check Privileges"

---

## SSL/HTTPS Setup

### Enable HTTPS

1. **Install SSL Certificate**
   - cPanel → AutoSSL or Let's Encrypt
   - Select your domain
   - Install certificate

2. **Update Site URL**
   - Go to Admin → Settings
   - Update site URL to use `https://`
   - Or edit config.php manually

3. **Force HTTPS**
   - Edit .htaccess file
   - Add:
   ```
   RewriteEngine On
   RewriteCond %{HTTPS} off
   RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
   ```

---

## Backup & Maintenance

### Regular Backups

1. **Backup Database**
   - cPanel → phpMyAdmin
   - Select database
   - Click "Export"
   - Save SQL file

2. **Backup Files**
   - File Manager → otp_system
   - Right-click → "Compress"
   - Download ZIP file

### Schedule Automatic Backups

1. **cPanel Backups**
   - cPanel → Backup
   - Configure backup schedule
   - Select what to backup

---

## Performance Optimization

### Enable Compression

Edit .htaccess:
```
<IfModule mod_deflate.c>
    AddOutputFilterByType DEFLATE text/html text/plain text/xml text/css text/javascript application/javascript
</IfModule>
```

### Enable Caching

Add to .htaccess:
```
<IfModule mod_expires.c>
    ExpiresActive On
    ExpiresByType text/css "access plus 1 month"
    ExpiresByType application/javascript "access plus 1 month"
    ExpiresByType image/jpeg "access plus 1 month"
    ExpiresByType image/png "access plus 1 month"
</IfModule>
```

### Optimize Database

1. **cPanel → phpMyAdmin**
2. **Select Database**
3. **Click "Operations"**
4. **Click "Optimize table"**

---

## Security Hardening

### Change Default Credentials

1. Change admin password immediately
2. Delete test accounts
3. Monitor user activity

### Protect Sensitive Files

1. .htaccess already blocks config.php
2. Verify permissions are correct
3. Regular security audits

### Monitor Activity

1. Check cPanel error logs
2. Review access logs
3. Monitor database changes

---

## Useful cPanel Tools

### phpMyAdmin
- Manage databases
- Run SQL queries
- Backup/restore data
- View table structure

### File Manager
- Upload/download files
- Edit files
- Change permissions
- Create folders

### Error Logs
- View PHP errors
- Debug issues
- Monitor performance

### Metrics
- View bandwidth usage
- Monitor disk space
- Check CPU usage

---

## Contact Support

If you need help:

1. **Check this guide** - Most issues are covered
2. **Check README.md** - System documentation
3. **Check SETUP_GUIDE.md** - Installation guide
4. **Contact hosting provider** - For cPanel issues
5. **Check error logs** - cPanel → Error Logs

---

## Quick Reference

| Item | Value |
|------|-------|
| Installation URL | `http://yourdomain.com/otp_system/install.php` |
| Login URL | `http://yourdomain.com/otp_system/login.php` |
| Database Host | `localhost` |
| Default Permissions | 755 (folders), 644 (files) |
| PHP Version | 7.4+ |
| MySQL Version | 5.7+ |

---

**Last Updated**: 2024
**Version**: 1.0
