<?php
require_once '../config.php';
requireAdmin();

// Get statistics
$total_users = $conn->query("SELECT COUNT(*) as count FROM users WHERE is_admin = 0")->fetch_assoc()['count'];
$total_whatsapp = $conn->query("SELECT COUNT(*) as count FROM otp_numbers WHERE service_type = 'whatsapp'")->fetch_assoc()['count'];
$total_facebook = $conn->query("SELECT COUNT(*) as count FROM otp_numbers WHERE service_type = 'facebook'")->fetch_assoc()['count'];
$available_whatsapp = $conn->query("SELECT COUNT(*) as count FROM otp_numbers WHERE service_type = 'whatsapp' AND is_available = 1")->fetch_assoc()['count'];
$available_facebook = $conn->query("SELECT COUNT(*) as count FROM otp_numbers WHERE service_type = 'facebook' AND is_available = 1")->fetch_assoc()['count'];
$pending_deposits = $conn->query("SELECT COUNT(*) as count FROM deposits WHERE status = 'pending'")->fetch_assoc()['count'];
$total_revenue = $conn->query("SELECT SUM(price) as total FROM purchase_history")->fetch_assoc()['total'] ?? 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - OTP System</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f7fa;
        }
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .navbar h2 {
            font-size: 24px;
        }
        .navbar-right {
            display: flex;
            gap: 20px;
            align-items: center;
        }
        .navbar-right a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .navbar-right a:hover {
            opacity: 0.8;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        .page-title {
            color: #333;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 30px;
        }
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: white;
            border-radius: 10px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .stat-icon {
            font-size: 40px;
            margin-bottom: 10px;
        }
        .stat-label {
            color: #666;
            font-size: 14px;
            margin-bottom: 10px;
            text-transform: uppercase;
        }
        .stat-value {
            color: #333;
            font-size: 28px;
            font-weight: 700;
        }
        .menu-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }
        .menu-item {
            background: white;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            transition: all 0.3s;
            cursor: pointer;
        }
        .menu-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.15);
        }
        .menu-item a {
            text-decoration: none;
            color: inherit;
        }
        .menu-item-icon {
            font-size: 40px;
            margin-bottom: 10px;
        }
        .menu-item-title {
            color: #333;
            font-weight: 600;
            font-size: 16px;
        }
        .section-title {
            color: #333;
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #667eea;
        }
    </style>
</head>
<body>
    <div class="navbar">
        <h2>🔐 OTP System - Admin</h2>
        <div class="navbar-right">
            <span><?php echo htmlspecialchars($_SESSION['email']); ?></span>
            <a href="logout.php">Logout</a>
        </div>
    </div>

    <div class="container">
        <h1 class="page-title">📊 Admin Dashboard</h1>

        <h3 class="section-title">📈 Statistics</h3>
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon">👥</div>
                <div class="stat-label">Total Users</div>
                <div class="stat-value"><?php echo $total_users; ?></div>
            </div>
            <div class="stat-card">
                <div class="stat-icon">📱</div>
                <div class="stat-label">WhatsApp Numbers</div>
                <div class="stat-value"><?php echo $total_whatsapp; ?> / <?php echo $available_whatsapp; ?></div>
            </div>
            <div class="stat-card">
                <div class="stat-icon">👥</div>
                <div class="stat-label">Facebook Numbers</div>
                <div class="stat-value"><?php echo $total_facebook; ?> / <?php echo $available_facebook; ?></div>
            </div>
            <div class="stat-card">
                <div class="stat-icon">💳</div>
                <div class="stat-label">Pending Deposits</div>
                <div class="stat-value"><?php echo $pending_deposits; ?></div>
            </div>
            <div class="stat-card">
                <div class="stat-icon">💰</div>
                <div class="stat-label">Total Revenue</div>
                <div class="stat-value">$<?php echo number_format($total_revenue, 2); ?></div>
            </div>
        </div>

        <h3 class="section-title">⚙️ Management</h3>
        <div class="menu-grid">
            <div class="menu-item">
                <a href="manage_otp.php">
                    <div class="menu-item-icon">🔑</div>
                    <div class="menu-item-title">Manage OTP Numbers</div>
                </a>
            </div>
            <div class="menu-item">
                <a href="manage_deposits.php">
                    <div class="menu-item-icon">💳</div>
                    <div class="menu-item-title">Manage Deposits</div>
                </a>
            </div>
            <div class="menu-item">
                <a href="manage_methods.php">
                    <div class="menu-item-icon">💰</div>
                    <div class="menu-item-title">Payment Methods</div>
                </a>
            </div>
            <div class="menu-item">
                <a href="manage_users.php">
                    <div class="menu-item-icon">👥</div>
                    <div class="menu-item-title">Manage Users</div>
                </a>
            </div>
            <div class="menu-item">
                <a href="settings.php">
                    <div class="menu-item-icon">⚙️</div>
                    <div class="menu-item-title">Settings</div>
                </a>
            </div>
        </div>
    </div>
</body>
</html>
