<?php
require_once '../config.php';
requireAdmin();

$error = '';
$success = '';

// Handle approve/reject
if (isset($_GET['action']) && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $action = sanitize($_GET['action']);
    
    if ($action == 'approve') {
        $deposit_query = "SELECT * FROM deposits WHERE id = $id";
        $deposit_result = $conn->query($deposit_query);
        $deposit = $deposit_result->fetch_assoc();
        
        if ($deposit) {
            // Add balance to user
            $conn->query("UPDATE users SET balance = balance + " . $deposit['amount'] . " WHERE id = " . $deposit['user_id']);
            
            // Update deposit status
            $conn->query("UPDATE deposits SET status = 'approved', approved_at = NOW() WHERE id = $id");
            
            $success = 'Deposit approved successfully!';
        }
    } elseif ($action == 'reject') {
        $conn->query("UPDATE deposits SET status = 'rejected', approved_at = NOW() WHERE id = $id");
        $success = 'Deposit rejected successfully!';
    }
}

// Get pending deposits
$deposits_query = "SELECT d.*, u.email, dm.method_name FROM deposits d 
                  JOIN users u ON d.user_id = u.id 
                  LEFT JOIN deposit_methods dm ON d.payment_method = dm.id 
                  ORDER BY d.created_at DESC";
$deposits_result = $conn->query($deposits_query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Deposits - Admin</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f7fa;
        }
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .navbar h2 {
            font-size: 24px;
        }
        .navbar-right {
            display: flex;
            gap: 20px;
            align-items: center;
        }
        .navbar-right a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        .back-link {
            margin-bottom: 20px;
        }
        .back-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
        }
        .page-title {
            color: #333;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 30px;
        }
        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            font-size: 14px;
        }
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .deposits-table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .deposits-table th {
            background: #667eea;
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: 600;
        }
        .deposits-table td {
            padding: 15px;
            border-bottom: 1px solid #eee;
        }
        .deposits-table tr:last-child td {
            border-bottom: none;
        }
        .status-badge {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .status-pending {
            background: #fff3cd;
            color: #856404;
        }
        .status-approved {
            background: #d4edda;
            color: #155724;
        }
        .status-rejected {
            background: #f8d7da;
            color: #721c24;
        }
        .btn {
            padding: 8px 15px;
            border: none;
            border-radius: 5px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
            font-size: 12px;
            text-decoration: none;
            display: inline-block;
        }
        .btn-approve {
            background: #28a745;
            color: white;
        }
        .btn-approve:hover {
            background: #218838;
        }
        .btn-reject {
            background: #dc3545;
            color: white;
        }
        .btn-reject:hover {
            background: #c82333;
        }
        .screenshot-link {
            color: #667eea;
            text-decoration: none;
        }
        .screenshot-link:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="navbar">
        <h2>🔐 OTP System - Admin</h2>
        <div class="navbar-right">
            <span><?php echo htmlspecialchars($_SESSION['email']); ?></span>
            <a href="logout.php">Logout</a>
        </div>
    </div>

    <div class="container">
        <div class="back-link">
            <a href="dashboard.php">← Back to Dashboard</a>
        </div>

        <h1 class="page-title">💳 Manage Deposits</h1>

        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
        <?php endif; ?>

        <table class="deposits-table">
            <thead>
                <tr>
                    <th>User Email</th>
                    <th>Amount</th>
                    <th>Method</th>
                    <th>Status</th>
                    <th>Screenshot</th>
                    <th>Date</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($deposits_result && $deposits_result->num_rows > 0): ?>
                    <?php while ($deposit = $deposits_result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($deposit['email']); ?></td>
                            <td>$<?php echo number_format($deposit['amount'], 2); ?></td>
                            <td><?php echo htmlspecialchars($deposit['method_name'] ?? 'N/A'); ?></td>
                            <td>
                                <span class="status-badge status-<?php echo $deposit['status']; ?>">
                                    <?php echo ucfirst($deposit['status']); ?>
                                </span>
                            </td>
                            <td>
                                <?php if ($deposit['screenshot_path']): ?>
                                    <a href="../uploads/<?php echo htmlspecialchars($deposit['screenshot_path']); ?>" target="_blank" class="screenshot-link">View</a>
                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            </td>
                            <td><?php echo date('M d, Y H:i', strtotime($deposit['created_at'])); ?></td>
                            <td>
                                <?php if ($deposit['status'] == 'pending'): ?>
                                    <a href="?action=approve&id=<?php echo $deposit['id']; ?>" class="btn btn-approve">Approve</a>
                                    <a href="?action=reject&id=<?php echo $deposit['id']; ?>" class="btn btn-reject">Reject</a>
                                <?php else: ?>
                                    <span style="color: #666;">—</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" style="text-align: center; color: #666;">No deposits found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
