<?php
require_once '../config.php';
requireAdmin();

$error = '';
$success = '';

// Handle bulk upload
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['otp_file'])) {
    $file = $_FILES['otp_file'];
    
    if ($file['error'] == 0) {
        $content = file_get_contents($file['tmp_name']);
        $lines = explode("\n", $content);
        
        $service_type = sanitize($_POST['service_type'] ?? 'whatsapp');
        $price = floatval($_POST['price'] ?? 0);
        
        if ($price <= 0) {
            $error = 'Please enter a valid price';
        } else {
            $added = 0;
            $failed = 0;
            
            foreach ($lines as $line) {
                $line = trim($line);
                if (empty($line)) continue;
                
                // Parse line: phone_number|otp_link
                $parts = explode('|', $line);
                if (count($parts) >= 2) {
                    $phone = sanitize(trim($parts[0]));
                    $link = sanitize(trim($parts[1]));
                    
                    $insert_query = "INSERT INTO otp_numbers (phone_number, otp_link, service_type, price, country) 
                                   VALUES ('$phone', '$link', '$service_type', $price, 'USA')";
                    
                    if ($conn->query($insert_query)) {
                        $added++;
                    } else {
                        $failed++;
                    }
                }
            }
            
            $success = "Bulk upload completed! Added: $added, Failed: $failed";
        }
    } else {
        $error = 'File upload failed';
    }
}

// Handle manual add
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['manual_add'])) {
    $phone = sanitize($_POST['phone_number'] ?? '');
    $link = sanitize($_POST['otp_link'] ?? '');
    $service_type = sanitize($_POST['service_type'] ?? 'whatsapp');
    $price = floatval($_POST['price'] ?? 0);
    
    if (empty($phone) || empty($link) || $price <= 0) {
        $error = 'Please fill all fields with valid data';
    } else {
        $insert_query = "INSERT INTO otp_numbers (phone_number, otp_link, service_type, price, country) 
                       VALUES ('$phone', '$link', '$service_type', $price, 'USA')";
        
        if ($conn->query($insert_query)) {
            $success = 'OTP number added successfully!';
        } else {
            $error = 'Failed to add OTP number: ' . $conn->error;
        }
    }
}

// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    if ($conn->query("DELETE FROM otp_numbers WHERE id = $id")) {
        $success = 'OTP number deleted successfully!';
    } else {
        $error = 'Failed to delete OTP number';
    }
}

// Get all OTP numbers
$otp_query = "SELECT * FROM otp_numbers ORDER BY created_at DESC LIMIT 100";
$otp_result = $conn->query($otp_query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage OTP - Admin</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f7fa;
        }
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .navbar h2 {
            font-size: 24px;
        }
        .navbar-right {
            display: flex;
            gap: 20px;
            align-items: center;
        }
        .navbar-right a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        .back-link {
            margin-bottom: 20px;
        }
        .back-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
        }
        .page-title {
            color: #333;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 30px;
        }
        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            font-size: 14px;
        }
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .form-container {
            background: white;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 30px;
        }
        .form-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 500;
        }
        input[type="text"],
        input[type="number"],
        input[type="file"],
        select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
        }
        input[type="text"]:focus,
        input[type="number"]:focus,
        input[type="file"]:focus,
        select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        .btn {
            padding: 12px 30px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 5px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
            font-size: 14px;
        }
        .btn:hover {
            transform: translateY(-2px);
        }
        .section-title {
            color: #333;
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #667eea;
        }
        .otp-table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .otp-table th {
            background: #667eea;
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: 600;
        }
        .otp-table td {
            padding: 15px;
            border-bottom: 1px solid #eee;
        }
        .otp-table tr:last-child td {
            border-bottom: none;
        }
        .status-badge {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .status-available {
            background: #d4edda;
            color: #155724;
        }
        .status-sold {
            background: #f8d7da;
            color: #721c24;
        }
        .service-badge {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .service-whatsapp {
            background: #d4edda;
            color: #155724;
        }
        .service-facebook {
            background: #cfe2ff;
            color: #084298;
        }
        .btn-delete {
            background: #dc3545;
            padding: 5px 10px;
            font-size: 12px;
        }
        .btn-delete:hover {
            background: #c82333;
        }
    </style>
</head>
<body>
    <div class="navbar">
        <h2>🔐 OTP System - Admin</h2>
        <div class="navbar-right">
            <span><?php echo htmlspecialchars($_SESSION['email']); ?></span>
            <a href="logout.php">Logout</a>
        </div>
    </div>

    <div class="container">
        <div class="back-link">
            <a href="dashboard.php">← Back to Dashboard</a>
        </div>

        <h1 class="page-title">🔑 Manage OTP Numbers</h1>

        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
        <?php endif; ?>

        <!-- Bulk Upload Section -->
        <div class="form-container">
            <h3 class="section-title">📤 Bulk Upload</h3>
            <form method="POST" enctype="multipart/form-data">
                <div class="form-row">
                    <div class="form-group">
                        <label for="service_type">Service Type</label>
                        <select id="service_type" name="service_type" required>
                            <option value="whatsapp">WhatsApp</option>
                            <option value="facebook">Facebook</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="price">Price ($)</label>
                        <input type="number" id="price" name="price" step="0.01" min="0.01" required>
                    </div>
                </div>
                <div class="form-group">
                    <label for="otp_file">Upload TXT File (Format: phone_number|otp_link)</label>
                    <input type="file" id="otp_file" name="otp_file" accept=".txt" required>
                </div>
                <button type="submit" class="btn">Upload OTP Numbers</button>
            </form>
        </div>

        <!-- Manual Add Section -->
        <div class="form-container">
            <h3 class="section-title">➕ Add Single OTP</h3>
            <form method="POST">
                <div class="form-row">
                    <div class="form-group">
                        <label for="phone_number">Phone Number</label>
                        <input type="text" id="phone_number" name="phone_number" required>
                    </div>
                    <div class="form-group">
                        <label for="otp_link">OTP Link</label>
                        <input type="text" id="otp_link" name="otp_link" required>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label for="service_type_manual">Service Type</label>
                        <select id="service_type_manual" name="service_type" required>
                            <option value="whatsapp">WhatsApp</option>
                            <option value="facebook">Facebook</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="price_manual">Price ($)</label>
                        <input type="number" id="price_manual" name="price" step="0.01" min="0.01" required>
                    </div>
                </div>
                <button type="submit" name="manual_add" class="btn">Add OTP Number</button>
            </form>
        </div>

        <!-- OTP List Section -->
        <h3 class="section-title">📋 OTP Numbers List</h3>
        <table class="otp-table">
            <thead>
                <tr>
                    <th>Phone Number</th>
                    <th>Service</th>
                    <th>Price</th>
                    <th>Status</th>
                    <th>OTP Link</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($otp_result && $otp_result->num_rows > 0): ?>
                    <?php while ($otp = $otp_result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($otp['phone_number']); ?></td>
                            <td>
                                <span class="service-badge service-<?php echo $otp['service_type']; ?>">
                                    <?php echo ucfirst($otp['service_type']); ?>
                                </span>
                            </td>
                            <td>$<?php echo number_format($otp['price'], 2); ?></td>
                            <td>
                                <span class="status-badge status-<?php echo $otp['is_available'] ? 'available' : 'sold'; ?>">
                                    <?php echo $otp['is_available'] ? 'Available' : 'Sold'; ?>
                                </span>
                            </td>
                            <td>
                                <small><?php echo htmlspecialchars(substr($otp['otp_link'], 0, 50)); ?>...</small>
                            </td>
                            <td>
                                <a href="?delete=<?php echo $otp['id']; ?>" class="btn btn-delete" onclick="return confirm('Are you sure?')">Delete</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" style="text-align: center; color: #666;">No OTP numbers found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
