<?php
require_once '../config.php';
requireAdmin();

$error = '';
$success = '';

// Handle settings update
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $whatsapp_price = floatval($_POST['whatsapp_price'] ?? 0);
    $facebook_price = floatval($_POST['facebook_price'] ?? 0);
    
    if ($whatsapp_price <= 0 || $facebook_price <= 0) {
        $error = 'Please enter valid prices';
    } else {
        $conn->query("UPDATE settings SET setting_value = '$whatsapp_price' WHERE setting_key = 'whatsapp_price'");
        $conn->query("UPDATE settings SET setting_value = '$facebook_price' WHERE setting_key = 'facebook_price'");
        $success = 'Settings updated successfully!';
    }
}

// Get current settings
$settings_query = "SELECT * FROM settings WHERE setting_key IN ('whatsapp_price', 'facebook_price')";
$settings_result = $conn->query($settings_query);
$settings = [];
while ($row = $settings_result->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - Admin</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f7fa;
        }
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .navbar h2 {
            font-size: 24px;
        }
        .navbar-right {
            display: flex;
            gap: 20px;
            align-items: center;
        }
        .navbar-right a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        .back-link {
            margin-bottom: 20px;
        }
        .back-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
        }
        .page-title {
            color: #333;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 30px;
        }
        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            font-size: 14px;
        }
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .form-container {
            background: white;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 500;
        }
        input[type="number"] {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
        }
        input[type="number"]:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        .btn {
            width: 100%;
            padding: 12px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 5px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
            font-size: 14px;
        }
        .btn:hover {
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
    <div class="navbar">
        <h2>🔐 OTP System - Admin</h2>
        <div class="navbar-right">
            <span><?php echo htmlspecialchars($_SESSION['email']); ?></span>
            <a href="logout.php">Logout</a>
        </div>
    </div>

    <div class="container">
        <div class="back-link">
            <a href="dashboard.php">← Back to Dashboard</a>
        </div>

        <h1 class="page-title">⚙️ Settings</h1>

        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
        <?php endif; ?>

        <div class="form-container">
            <form method="POST">
                <div class="form-group">
                    <label for="whatsapp_price">WhatsApp Price ($)</label>
                    <input type="number" id="whatsapp_price" name="whatsapp_price" step="0.01" min="0.01" value="<?php echo isset($settings['whatsapp_price']) ? $settings['whatsapp_price'] : '5.00'; ?>" required>
                </div>
                <div class="form-group">
                    <label for="facebook_price">Facebook Price ($)</label>
                    <input type="number" id="facebook_price" name="facebook_price" step="0.01" min="0.01" value="<?php echo isset($settings['facebook_price']) ? $settings['facebook_price'] : '3.00'; ?>" required>
                </div>
                <button type="submit" class="btn">Save Settings</button>
            </form>
        </div>
    </div>
</body>
</html>
