<?php
require_once 'config.php';

/**
 * Link Proxy Handler
 * This file handles link masking/proxying
 * When user accesses: domain.com/proxy.php?token=xxxxx
 * It redirects to the actual OTP link stored in database
 * But the user sees the domain.com link
 */

if (!isset($_GET['token'])) {
    http_response_code(404);
    die('Not found');
}

$token = sanitize($_GET['token']);

// Get the OTP link from database using token
// For security, we use a hash of the link as token
$query = "SELECT otp_link FROM otp_numbers WHERE MD5(otp_link) = MD5('$token') LIMIT 1";
$result = $conn->query($query);

if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $actual_link = $row['otp_link'];
    
    // Redirect to actual link
    header('Location: ' . $actual_link);
    exit();
} else {
    http_response_code(404);
    die('Link not found');
}
?>
