<?php
require_once '../config.php';
requireLogin();

$user_id = $_SESSION['user_id'];
$error = '';
$success = '';

// Get deposit methods
$methods_query = "SELECT * FROM deposit_methods WHERE is_active = 1";
$methods_result = $conn->query($methods_query);

// Handle deposit request
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $amount = floatval($_POST['amount'] ?? 0);
    $method_id = intval($_POST['method_id'] ?? 0);

    if ($amount <= 0) {
        $error = 'Please enter a valid amount';
    } elseif ($method_id <= 0) {
        $error = 'Please select a payment method';
    } else {
        // Handle file upload
        $screenshot_path = '';
        if (isset($_FILES['screenshot']) && $_FILES['screenshot']['error'] == 0) {
            $allowed = ['jpg', 'jpeg', 'png', 'gif'];
            $filename = $_FILES['screenshot']['name'];
            $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));

            if (in_array($ext, $allowed)) {
                $new_filename = 'deposit_' . $user_id . '_' . time() . '.' . $ext;
                $upload_path = '../uploads/' . $new_filename;

                if (move_uploaded_file($_FILES['screenshot']['tmp_name'], $upload_path)) {
                    $screenshot_path = $new_filename;
                } else {
                    $error = 'Failed to upload screenshot';
                }
            } else {
                $error = 'Invalid file format. Only JPG, PNG, GIF allowed.';
            }
        }

        if (empty($error)) {
            $screenshot_path_db = $conn->real_escape_string($screenshot_path);
            $insert_query = "INSERT INTO deposits (user_id, amount, payment_method, screenshot_path, status) 
                           VALUES ($user_id, $amount, $method_id, '$screenshot_path_db', 'pending')";

            if ($conn->query($insert_query)) {
                $success = 'Deposit request submitted successfully! Waiting for admin approval.';
            } else {
                $error = 'Failed to submit deposit request: ' . $conn->error;
            }
        }
    }
}

// Get user's deposit history
$history_query = "SELECT d.*, dm.method_name FROM deposits d 
                 LEFT JOIN deposit_methods dm ON d.payment_method = dm.id 
                 WHERE d.user_id = $user_id 
                 ORDER BY d.created_at DESC LIMIT 10";
$history_result = $conn->query($history_query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Deposit - OTP System</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f7fa;
        }
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .navbar h2 {
            font-size: 24px;
        }
        .navbar-right {
            display: flex;
            gap: 20px;
            align-items: center;
        }
        .navbar-right a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        .back-link {
            margin-bottom: 20px;
        }
        .back-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
        }
        .page-title {
            color: #333;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 30px;
        }
        .form-container {
            background: white;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 30px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 500;
        }
        input[type="number"],
        input[type="file"],
        select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
            transition: border-color 0.3s;
        }
        input[type="number"]:focus,
        input[type="file"]:focus,
        select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            font-size: 14px;
        }
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: 600;
            cursor: pointer;
            border: none;
            transition: transform 0.2s;
            font-size: 14px;
            width: 100%;
        }
        .btn:hover {
            transform: translateY(-2px);
        }
        .history-title {
            color: #333;
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #667eea;
        }
        .history-table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .history-table th {
            background: #667eea;
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: 600;
        }
        .history-table td {
            padding: 15px;
            border-bottom: 1px solid #eee;
        }
        .history-table tr:last-child td {
            border-bottom: none;
        }
        .status-badge {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .status-pending {
            background: #fff3cd;
            color: #856404;
        }
        .status-approved {
            background: #d4edda;
            color: #155724;
        }
        .status-rejected {
            background: #f8d7da;
            color: #721c24;
        }
    </style>
</head>
<body>
    <div class="navbar">
        <h2>🔐 OTP System</h2>
        <div class="navbar-right">
            <span><?php echo htmlspecialchars($_SESSION['email']); ?></span>
            <a href="logout.php">Logout</a>
        </div>
    </div>

    <div class="container">
        <div class="back-link">
            <a href="dashboard.php">← Back to Dashboard</a>
        </div>

        <h1 class="page-title">💳 Deposit Funds</h1>

        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
        <?php endif; ?>

        <div class="form-container">
            <form method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="amount">Amount ($)</label>
                    <input type="number" id="amount" name="amount" step="0.01" min="0.01" required>
                </div>

                <div class="form-group">
                    <label for="method_id">Payment Method</label>
                    <select id="method_id" name="method_id" required>
                        <option value="">Select a payment method</option>
                        <?php while ($method = $methods_result->fetch_assoc()): ?>
                            <option value="<?php echo $method['id']; ?>">
                                <?php echo htmlspecialchars($method['method_name']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="screenshot">Payment Screenshot</label>
                    <input type="file" id="screenshot" name="screenshot" accept="image/*" required>
                </div>

                <button type="submit" class="btn">Submit Deposit Request</button>
            </form>
        </div>

        <h2 class="history-title">📋 Deposit History</h2>
        <table class="history-table">
            <thead>
                <tr>
                    <th>Amount</th>
                    <th>Method</th>
                    <th>Status</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($history_result && $history_result->num_rows > 0): ?>
                    <?php while ($deposit = $history_result->fetch_assoc()): ?>
                        <tr>
                            <td>$<?php echo number_format($deposit['amount'], 2); ?></td>
                            <td><?php echo htmlspecialchars($deposit['method_name'] ?? 'N/A'); ?></td>
                            <td>
                                <span class="status-badge status-<?php echo $deposit['status']; ?>">
                                    <?php echo ucfirst($deposit['status']); ?>
                                </span>
                            </td>
                            <td><?php echo date('M d, Y H:i', strtotime($deposit['created_at'])); ?></td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4" style="text-align: center; color: #666;">No deposit history</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
