<?php
require_once '../config.php';
requireLogin();

$user_id = $_SESSION['user_id'];
$error = '';
$success = '';

// Get user balance
$user_query = "SELECT balance FROM users WHERE id = $user_id";
$user_result = $conn->query($user_query);
$user = $user_result->fetch_assoc();

// Get prices
$prices_query = "SELECT * FROM settings WHERE setting_key IN ('whatsapp_price', 'facebook_price')";
$prices_result = $conn->query($prices_query);
$prices = [];
while ($row = $prices_result->fetch_assoc()) {
    $prices[$row['setting_key']] = $row['setting_value'];
}

// Handle OTP purchase
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['service_type'])) {
    $service_type = sanitize($_POST['service_type']);
    $price_key = $service_type . '_price';
    $price = isset($prices[$price_key]) ? floatval($prices[$price_key]) : 0;

    if ($user['balance'] < $price) {
        $error = 'Insufficient balance. Please deposit funds.';
    } else {
        // Get available OTP number
        $otp_query = "SELECT * FROM otp_numbers WHERE is_available = 1 AND service_type = '$service_type' LIMIT 1";
        $otp_result = $conn->query($otp_query);

        if ($otp_result && $otp_result->num_rows > 0) {
            $otp = $otp_result->fetch_assoc();

            // Deduct balance
            $new_balance = $user['balance'] - $price;
            $conn->query("UPDATE users SET balance = $new_balance WHERE id = $user_id");

            // Mark OTP as purchased
            $conn->query("UPDATE otp_numbers SET is_available = 0, purchased_by = $user_id, purchased_at = NOW() WHERE id = " . $otp['id']);

            // Add to history
            $conn->query("INSERT INTO purchase_history (user_id, otp_number_id, phone_number, otp_link, service_type, price) 
                         VALUES ($user_id, " . $otp['id'] . ", '" . $otp['phone_number'] . "', '" . $otp['otp_link'] . "', '$service_type', $price)");

            $success = 'OTP purchased successfully!';
            $user['balance'] = $new_balance;
        } else {
            $error = 'No available OTP numbers for this service.';
        }
    }
}

// Get available numbers
$whatsapp_query = "SELECT COUNT(*) as count FROM otp_numbers WHERE is_available = 1 AND service_type = 'whatsapp'";
$facebook_query = "SELECT COUNT(*) as count FROM otp_numbers WHERE is_available = 1 AND service_type = 'facebook'";

$whatsapp_count = $conn->query($whatsapp_query)->fetch_assoc()['count'];
$facebook_count = $conn->query($facebook_query)->fetch_assoc()['count'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Get OTP - OTP System</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f7fa;
        }
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .navbar h2 {
            font-size: 24px;
        }
        .navbar-right {
            display: flex;
            gap: 20px;
            align-items: center;
        }
        .navbar-right a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        .back-link {
            margin-bottom: 20px;
        }
        .back-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
        }
        .back-link a:hover {
            text-decoration: underline;
        }
        .page-title {
            color: #333;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 10px;
        }
        .balance-info {
            background: white;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .balance-info strong {
            color: #667eea;
        }
        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            font-size: 14px;
        }
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .services-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
        }
        .service-card {
            background: white;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            text-align: center;
        }
        .service-icon {
            font-size: 50px;
            margin-bottom: 15px;
        }
        .service-name {
            color: #333;
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 10px;
        }
        .service-available {
            color: #666;
            font-size: 14px;
            margin-bottom: 15px;
        }
        .service-available strong {
            color: #667eea;
        }
        .service-price {
            color: #333;
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }
        .service-price small {
            font-size: 14px;
            color: #666;
        }
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: 600;
            cursor: pointer;
            border: none;
            transition: transform 0.2s;
            font-size: 14px;
            width: 100%;
        }
        .btn:hover {
            transform: translateY(-2px);
        }
        .btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
    </style>
</head>
<body>
    <div class="navbar">
        <h2>🔐 OTP System</h2>
        <div class="navbar-right">
            <span><?php echo htmlspecialchars($_SESSION['email']); ?></span>
            <a href="logout.php">Logout</a>
        </div>
    </div>

    <div class="container">
        <div class="back-link">
            <a href="dashboard.php">← Back to Dashboard</a>
        </div>

        <h1 class="page-title">🔑 Get OTP</h1>

        <div class="balance-info">
            Current Balance: <strong>$<?php echo number_format($user['balance'], 2); ?></strong>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
        <?php endif; ?>

        <div class="services-grid">
            <div class="service-card">
                <div class="service-icon">📱</div>
                <div class="service-name">WhatsApp</div>
                <div class="service-available">Available: <strong><?php echo $whatsapp_count; ?></strong></div>
                <div class="service-price">$<?php echo isset($prices['whatsapp_price']) ? number_format($prices['whatsapp_price'], 2) : '0.00'; ?></div>
                <form method="POST" style="display: inline;">
                    <input type="hidden" name="service_type" value="whatsapp">
                    <button type="submit" class="btn" <?php echo $whatsapp_count == 0 ? 'disabled' : ''; ?>>
                        <?php echo $whatsapp_count > 0 ? 'Purchase Now' : 'Out of Stock'; ?>
                    </button>
                </form>
            </div>

            <div class="service-card">
                <div class="service-icon">👥</div>
                <div class="service-name">Facebook</div>
                <div class="service-available">Available: <strong><?php echo $facebook_count; ?></strong></div>
                <div class="service-price">$<?php echo isset($prices['facebook_price']) ? number_format($prices['facebook_price'], 2) : '0.00'; ?></div>
                <form method="POST" style="display: inline;">
                    <input type="hidden" name="service_type" value="facebook">
                    <button type="submit" class="btn" <?php echo $facebook_count == 0 ? 'disabled' : ''; ?>>
                        <?php echo $facebook_count > 0 ? 'Purchase Now' : 'Out of Stock'; ?>
                    </button>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
