<?php
require_once '../config.php';
requireLogin();

$user_id = $_SESSION['user_id'];

// Get SITE_URL from config
$site_url = SITE_URL;

// Get purchase history
$history_query = "SELECT * FROM purchase_history WHERE user_id = $user_id ORDER BY purchase_date DESC";
$history_result = $conn->query($history_query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>History - OTP System</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f7fa;
        }
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .navbar h2 {
            font-size: 24px;
        }
        .navbar-right {
            display: flex;
            gap: 20px;
            align-items: center;
        }
        .navbar-right a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        .back-link {
            margin-bottom: 20px;
        }
        .back-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
        }
        .page-title {
            color: #333;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 30px;
        }
        .history-table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .history-table th {
            background: #667eea;
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: 600;
        }
        .history-table td {
            padding: 15px;
            border-bottom: 1px solid #eee;
        }
        .history-table tr:last-child td {
            border-bottom: none;
        }
        .phone-number {
            font-weight: 600;
            color: #333;
        }
        .otp-link {
            color: #667eea;
            text-decoration: none;
            word-break: break-all;
            font-size: 12px;
        }
        .otp-link:hover {
            text-decoration: underline;
        }
        .service-badge {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .service-whatsapp {
            background: #d4edda;
            color: #155724;
        }
        .service-facebook {
            background: #cfe2ff;
            color: #084298;
        }
        .empty-message {
            text-align: center;
            padding: 40px;
            color: #666;
        }
        .copy-btn {
            background: #667eea;
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 3px;
            cursor: pointer;
            font-size: 12px;
        }
        .copy-btn:hover {
            background: #764ba2;
        }
    </style>
</head>
<body>
    <div class="navbar">
        <h2>🔐 OTP System</h2>
        <div class="navbar-right">
            <span><?php echo htmlspecialchars($_SESSION['email']); ?></span>
            <a href="logout.php">Logout</a>
        </div>
    </div>

    <div class="container">
        <div class="back-link">
            <a href="dashboard.php">← Back to Dashboard</a>
        </div>

        <h1 class="page-title">📜 Purchase History</h1>

        <?php if ($history_result && $history_result->num_rows > 0): ?>
            <table class="history-table">
                <thead>
                    <tr>
                        <th>Phone Number</th>
                        <th>Service</th>
                        <th>Price</th>
                        <th>OTP Link</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($record = $history_result->fetch_assoc()): ?>
                        <tr>
                            <td class="phone-number"><?php echo htmlspecialchars($record['phone_number']); ?></td>
                            <td>
                                <span class="service-badge service-<?php echo $record['service_type']; ?>">
                                    <?php echo ucfirst($record['service_type']); ?>
                                </span>
                            </td>
                            <td>$<?php echo number_format($record['price'], 2); ?></td>
                            <td>
                                <a href="<?php echo htmlspecialchars($record['otp_link']); ?>" target="_blank" class="otp-link">
                                    View OTP
                                </a>
                            </td>
                            <td><?php echo date('M d, Y H:i', strtotime($record['purchase_date'])); ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="empty-message">
                <p>No purchase history yet. Start by purchasing an OTP!</p>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
